/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var advanced_1 = require("report-errors/advanced");
var wer_api_windows_1 = require("wer-api-windows");
exports.WerConsent = wer_api_windows_1.WerConsent;
var Internal_1 = require("./Internal");
var WatsonReporter = (function (_super) {
    __extends(WatsonReporter, _super);
    function WatsonReporter(options) {
        if (options === void 0) { options = {}; }
        _super.call(this, true);
        this.consent = advanced_1.defaultValue(wer_api_windows_1.WerConsent.WerConsentNotAsked, options.consent);
        this.sendReport = advanced_1.defaultValue(true, options.sendReport);
        this.nonCritical = advanced_1.defaultValue(false, options.nonCritical);
        this.reportDirectory = advanced_1.defaultValue(process.env.TEMP, options.reportDirectory);
        this.keepFile = advanced_1.defaultValue(true, options.keepReportFile);
    }
    WatsonReporter.prototype.report = function (err) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var additionalFiles = [];
            var reportInfo = Internal_1.writeFile(err, _this.reportDirectory);
            var EVENT_TYPE = "WWAJSE";
            var params = Internal_1.setParamsWWAJSE(reportInfo, err.packageInfo, err.exeName);
            var files = null;
            if (additionalFiles) {
                files = additionalFiles;
            }
            else {
                files = [];
            }
            var file = {
                path: reportInfo.reportFilePath,
                fileType: wer_api_windows_1.WerFileType.Other,
                anonymousData: true,
                deleteWhenDone: _this.keepFile
            };
            files.push(file);
            var reportType;
            if (_this.nonCritical) {
                reportType = wer_api_windows_1.WerReportType.NonCritical;
            }
            else {
                reportType = wer_api_windows_1.WerReportType.Critical;
            }
            if (_this.sendReport) {
                wer_api_windows_1.CreateWerReport(EVENT_TYPE, reportType, _this.consent, 0, files, params);
            }
            else {
                console.log(EVENT_TYPE);
                console.log(_this.consent);
                console.log(files);
                console.log(params);
            }
            resolve(reportInfo.reportFilePath);
        });
    };
    return WatsonReporter;
}(advanced_1.ReportingChannel));
exports.WatsonReporter = WatsonReporter;

// SIG // Begin signature block
// SIG // MIIiMAYJKoZIhvcNAQcCoIIiITCCIh0CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // A3BxskT8+LZlR9IHdOWnXJAauSlrxLTgN/Nt01QohrOg
// SIG // gguEMIIFDDCCA/SgAwIBAgITMwAAAU/nxmLJRvSpfwAA
// SIG // AAABTzANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTE2MTExNzIxNTkxNFoX
// SIG // DTE4MDIxNzIxNTkxNFowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBALSJkIp2DKzFPaG8gejXUAi7
// SIG // WmmnrsfMuFu9OA8hUUYII9G9Iplztyjv9werK/lI96UU
// SIG // BalNJBttYZacg50zwCx5mfBd8+zVRN+lzVn6dq0GP8ZK
// SIG // A+bqLZQQwmZv/WLQUIrRIpEjl2U0ocSaAl6S4rh8KHjC
// SIG // XuNG98rvOFeIrFYGWMqYG8eo1142rppFMOO2tz0Ywqcn
// SIG // sHlNU9gy5najUCr2P7q7QR4khk2Ym3qe9izivJBgZfuW
// SIG // afrgE2jiiSoudRidwm24IfSZXip/MaCnDczvTxFu/klC
// SIG // TmHeN8srnkDvzqtecAhzpXJ7t0bOWzJTXYo5UW+w16h4
// SIG // 3aMob17uQh8CAwEAAaOCAXswggF3MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjc9BgEGCCsGAQUFBwMDMB0GA1UdDgQWBBSS
// SIG // DqERcbYvVQ3DD/TJXHQuWgxqvzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwODY1
// SIG // K2I0YjEyODc4LWUyOTMtNDNlOS1iMjFlLTdkMzA3MTlk
// SIG // NDUyZjAfBgNVHSMEGDAWgBTm/F97uyIAWORyTrX0IXQj
// SIG // MubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNDb2RTaWdQQ0FfMjAxMC0wNy0wNi5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNp
// SIG // Z1BDQV8yMDEwLTA3LTA2LmNydDAMBgNVHRMBAf8EAjAA
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQARwLlqQzX+hbE4gA24
// SIG // dHUsjXFJuDxB7S294gY2kHYrieW2gemG4xiMlpMyQqen
// SIG // 9rc0JTnQxnpD6tt3cMzU6ULrqMVVAnV4ntgQvgcbypRj
// SIG // +zwPce7UVWfXKfZqvwe85Y+C6vih4nMzPxSSXqG6ZVc3
// SIG // RYWAXNYsxos8aoejBxHL7NlxOCA1JD1UvcxVifR3EJvl
// SIG // maoPrsY8jp/aAE/PfeGzwCD3UjH3IkjVYY1/JgIZfYPM
// SIG // YZMq3bjc4gizp9/hBHdgyPSsNcsx5Wx1UcU3exNqTpVr
// SIG // j0CeyE0+rr1ZxSDWwnitt2RbO9DAFXA0FOXFnqYcx/T/
// SIG // 9stIweKN827OqrSgMIIGcDCCBFigAwIBAgIKYQxSTAAA
// SIG // AAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6Q5kUHlntcTj/QkA
// SIG // TJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX
// SIG // 0o/9RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe
// SIG // 0dLCiR5xlM21f0u0rwjYzIjWaxeUOpPOJj/s5v40mFfV
// SIG // HV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
// SIG // vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IU
// SIG // yMHIiiYKWX8H7P8O7YASNUwSpr5SW/Wm2uCLC0h31oVH
// SIG // 1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZM4Bq
// SIG // iU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFOb8X3u7IgBY5HJO
// SIG // tfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjE
// SIG // MFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcB
// SIG // AQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // XzIwMTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAGnTv
// SIG // V08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI
// SIG // 4zSp24G43B4AvtI1b6/lf3mVd+UC1PHr2M1OHhthosJa
// SIG // IxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMhKeWloWmM
// SIG // IpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxp
// SIG // hnY9UdumOUjJN2FtB91TGcun1mHCv+KDqw/ga5uV1n0o
// SIG // UbCJSlGkmmzItx9KGg5pqdfcwX7RSXCqtq27ckdjF/qm
// SIG // 1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVB
// SIG // y78dTMgW77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1z
// SIG // NfM8rlSyUkdqwKoTldKOEdqZZ14yjPs3hdHcdYWch8Za
// SIG // V4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7be
// SIG // BVaXevfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7K
// SIG // sYxuqh3khdpHM2KPpMmRM19xHkCvmGXJIuhCISWKHC1g
// SIG // 2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
// SIG // HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteS
// SIG // LM43Wj5AQjGkHxAIwlacvyRdUQKdannSF9PawZSOB3sl
// SIG // cUSrBmrm1MbfI5qWdcUxghYEMIIWAAIBATCBlTB+MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3Nv
// SIG // ZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAABT+fG
// SIG // YslG9Kl/AAAAAAFPMA0GCWCGSAFlAwQCAQUAoIHzMBkG
// SIG // CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQB
// SIG // gjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJ
// SIG // BDEiBCA+hPOjoVFoKsR/mndiIBKp4GTE+kS86jWL2QXs
// SIG // 6Cm4QzCBhgYKKwYBBAGCNwIBDDF4MHagXIBaAGkAbgBk
// SIG // AGUAeABfADYAMwAyADEAZQA3ADIAZAAtADQAMgBhAGEA
// SIG // LQA0AGMAZAA5AC0AOABhAGUAOQAtAGUAZgAzADgAMQAz
// SIG // AGUAYwA0ADQAYwBhAC4AagBzoRaAFGh0dHA6Ly9taWNy
// SIG // b3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBAIasX/89
// SIG // rx3PCIZKQqCWZZyKo2Yjs4h2d3xA5F+lb6QR5UvApc2A
// SIG // 07C2OLApTEGcG1UYAva2Ub6w7hbAHpbMN+qT9AUKalpP
// SIG // 25hp95W220jVGkBHVt+jRJ/ZAbRXnXpG8JVytr1LzYJk
// SIG // 45Ag32iRocYOLoVat8kqjY3DCp1RRDICwBI2KtVLCLOX
// SIG // o5H+CBiUzeWR2w2ekxoX+aALNG2Di1aldFlFSwt57ha/
// SIG // zF4OA91ir2KX98O0igW54VsPs72EpTlz1hI+wjZJ86eI
// SIG // 2TjrYjzZFdZmGmYkzBFfIrElV8eL+JCyKGT+Ec/09CJo
// SIG // HXahPe9J+EiyuPFFiv4Qt1jE5tKhghNJMIITRQYKKwYB
// SIG // BAGCNwMDATGCEzUwghMxBgkqhkiG9w0BBwKgghMiMIIT
// SIG // HgIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBPAYLKoZIhvcN
// SIG // AQkQAQSgggErBIIBJzCCASMCAQEGCisGAQQBhFkKAwEw
// SIG // MTANBglghkgBZQMEAgEFAAQgWrAsK0htlkOS/O4jmp6H
// SIG // c+ypyFVWeEyuKCPyplYJ9SICBlg/MUo6rxgSMjAxNjEy
// SIG // MjgwMDU4MDMuNjZaMAcCAQGAAgH0oIG5pIG2MIGzMQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScw
// SIG // JQYDVQQLEx5uQ2lwaGVyIERTRSBFU046RjUyOC0zNzc3
// SIG // LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFNlcnZpY2Wggg7NMIIGcTCCBFmgAwIBAgIKYQmB
// SIG // KgAAAAAAAjANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcN
// SIG // MTAwNzAxMjEzNjU1WhcNMjUwNzAxMjE0NjU1WjB8MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3Nv
// SIG // ZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBAKkdDbx3EYo6IOz8
// SIG // E5f1+n9plGt0VBDVpQoAgoX77XxoSyxfxcPlYcJ2tz5m
// SIG // K1vwFVMnBDEfQRsalR3OCROOfGEwWbEwRA/xYIiEVEMM
// SIG // 1024OAizQt2TrNZzMFcmgqNFDdDq9UeBzb8kYDJYYEby
// SIG // WEeGMoQedGFnkV+BVLHPk0ySwcSmXdFhE24oxhr5hoC7
// SIG // 32H8RsEnHSRnEnIaIYqvS2SJUGKxXf13Hz3wV3WsvYpC
// SIG // TUBR0Q+cBj5nf/VmwAOWRH7v0Ev9buWayrGo8noqCjHw
// SIG // 2k4GkbaICDXoeByw6ZnNPOcvRLqn9NxkvaQBwSAJk3jN
// SIG // /LzAyURdXhacAQVPIk0CAwEAAaOCAeYwggHiMBAGCSsG
// SIG // AQQBgjcVAQQDAgEAMB0GA1UdDgQWBBTVYzpcijGQ80N7
// SIG // fEYbxTNoWoVtVTAZBgkrBgEEAYI3FAIEDB4KAFMAdQBi
// SIG // AEMAQTALBgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB
// SIG // /zAfBgNVHSMEGDAWgBTV9lbLj+iiXGJo0T2UkFvXzpoY
// SIG // xDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNS
// SIG // b29DZXJBdXRfMjAxMC0wNi0yMy5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY1Jvb0NlckF1
// SIG // dF8yMDEwLTA2LTIzLmNydDCBoAYDVR0gAQH/BIGVMIGS
// SIG // MIGPBgkrBgEEAYI3LgMwgYEwPQYIKwYBBQUHAgEWMWh0
// SIG // dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9QS0kvZG9jcy9D
// SIG // UFMvZGVmYXVsdC5odG0wQAYIKwYBBQUHAgIwNB4yIB0A
// SIG // TABlAGcAYQBsAF8AUABvAGwAaQBjAHkAXwBTAHQAYQB0
// SIG // AGUAbQBlAG4AdAAuIB0wDQYJKoZIhvcNAQELBQADggIB
// SIG // AAfmiFEN4sbgmD+BcQM9naOhIW+z66bM9TG+zwXiqf76
// SIG // V20ZMLPCxWbJat/15/B4vceoniXj+bzta1RXCCtRgkQS
// SIG // +7lTjMz0YBKKdsxAQEGb3FwX/1z5Xhc1mCRWS3TvQhDI
// SIG // r79/xn/yN31aPxzymXlKkVIArzgPF/UveYFl2am1a+TH
// SIG // zvbKegBvSzBEJCI8z+0DpZaPWSm8tv0E4XCfMkon/VWv
// SIG // L/625Y4zu2JfmttXQOnxzplmkIz/amJ/3cVKC5Em4jns
// SIG // GUpxY517IW3DnKOiPPp/fZZqkHimbdLhnPkd/DjYlPTG
// SIG // pQqWhqS9nhquBEKDuLWAmyI4ILUl5WTs9/S/fmNZJQ96
// SIG // LjlXdqJxqgaKD4kWumGnEcua2A5HmoDF0M2n0O99g/Dh
// SIG // O3EJ3110mCIIYdqwUB5vvfHhAN/nMQekkzr3ZUd46Pio
// SIG // SKv33nJ+YWtvd6mBy6cJrDm77MbL2IK0cs0d9LiFAR6A
// SIG // +xuJKlQ5slvayA1VmXqHczsI5pgt6o3gMy4SKfXAL1Qn
// SIG // IffIrE7aKLixqduWsqdCosnPGUFN4Ib5KpqjEWYw07t0
// SIG // MkvfY3v1mYovG8chr1m1rtxEPJdQcdeh0sVV42neV8HR
// SIG // 3jDA/czmTfsNv11P6Z0eGTgvvM9YBS7vDaBQNdrvCScc
// SIG // 1bN+NR4Iuto229Nfj950iEkSMIIE2jCCA8KgAwIBAgIT
// SIG // MwAAALCG6ZIgCl3q+AAAAAAAsDANBgkqhkiG9w0BAQsF
// SIG // ADB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1N
// SIG // aWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDAeFw0x
// SIG // NjA5MDcxNzU2NTZaFw0xODA5MDcxNzU2NTZaMIGzMQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScw
// SIG // JQYDVQQLEx5uQ2lwaGVyIERTRSBFU046RjUyOC0zNzc3
// SIG // LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFNlcnZpY2UwggEiMA0GCSqGSIb3DQEBAQUAA4IB
// SIG // DwAwggEKAoIBAQDw5fCNlFmpmtdsCQd3FCFZXbc9eLg1
// SIG // rfUwMf/O4f/W6RrJg5gj+5AQwZLsOrxQbJC9XPFrrUyi
// SIG // 9WGlh+EprKM8Et9/xACCzr20Cl/LuduatxktWu0HAK1U
// SIG // /TOs9vgSJEokZ1fauEuhrA+A+Tm9IA21p8QsS/GhVuby
// SIG // Lye5JsEzJdkrDDByUIRrkmqVjPL6CE24LiTVQ9Pc6/N0
// SIG // aoizybRg3MllrV8J5RFqFDTB5FcGEkbmoL2EWiRCQ/a8
// SIG // 9CxVmVqNs4imqhKUIr6GtUqJjKpHsKDFHxuPnPBibVSd
// SIG // MtOpxJtT6blyO78Xnq9YXJ3GK1Ahu9iWzDbvjaZz2a27
// SIG // Q3AVAgMBAAGjggEbMIIBFzAdBgNVHQ4EFgQU/KgHUtnv
// SIG // Kf6YQzwVXHRet39z4K8wHwYDVR0jBBgwFoAU1WM6XIox
// SIG // kPNDe3xGG8UzaFqFbVUwVgYDVR0fBE8wTTBLoEmgR4ZF
// SIG // aHR0cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwv
// SIG // cHJvZHVjdHMvTWljVGltU3RhUENBXzIwMTAtMDctMDEu
// SIG // Y3JsMFoGCCsGAQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+
// SIG // aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0
// SIG // cy9NaWNUaW1TdGFQQ0FfMjAxMC0wNy0wMS5jcnQwDAYD
// SIG // VR0TAQH/BAIwADATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQsFAAOCAQEAkv2A93W9ZZA+F83VFYPF
// SIG // jgKRO6xOfWDvjzkGk5DjD6pFPYk/Av3sb7hQkAlshNI3
// SIG // IZmxwYZ2HeQNxo7/GOCi+ka1hXd0bk4MREXQvNK2BH5w
// SIG // Sw/WqwdpVkp2ZOj5qkejo4bc9M9EuEkQW2eP0dp5rjrd
// SIG // h1MG6I9q/H/X5KOGRRUNkWIiOpBK49hoAUnJLQ5reGwR
// SIG // AvSPTRFgc6gDIQ2X4w9ydbv96A646/wgQZ2Ok/3FM3M+
// SIG // OXq9ajQeOUdiEbUc71f0c4Nxn6gUZb7kA45NbcQBMxt+
// SIG // V+yh8xyXqTin9Kg6OfmJNfxdoyKuCr2NDKsxEm7pvWEW
// SIG // 7PQZOiSFYl+psqGCA3YwggJeAgEBMIHjoYG5pIG2MIGz
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BS
// SIG // MScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046RjUyOC0z
// SIG // Nzc3LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1l
// SIG // LVN0YW1wIFNlcnZpY2WiJQoBATAJBgUrDgMCGgUAAxUA
// SIG // vIT7nVsS2sc2hTuIZp6jFhjVzByggcIwgb+kgbwwgbkx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIx
// SIG // JzAlBgNVBAsTHm5DaXBoZXIgTlRTIEVTTjo1N0Y2LUMx
// SIG // RTAtNTU0QzErMCkGA1UEAxMiTWljcm9zb2Z0IFRpbWUg
// SIG // U291cmNlIE1hc3RlciBDbG9jazANBgkqhkiG9w0BAQUF
// SIG // AAIFANwNhAgwIhgPMjAxNjEyMjgwMDIxMjhaGA8yMDE2
// SIG // MTIyOTAwMjEyOFowdDA6BgorBgEEAYRZCgQBMSwwKjAK
// SIG // AgUA3A2ECAIBADAHAgEAAgIDvzAHAgEAAgIX6jAKAgUA
// SIG // 3A7ViAIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEE
// SIG // AYRZCgMBoAowCAIBAAIDFuNgoQowCAIBAAIDB6EgMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQAyuqUJMJCuOVNvCziwOxZ1
// SIG // 8Vganx0oNuZT5/aNMxCIdUQdYWGXRZ7gid4VNlI0kWVR
// SIG // HBg2R54eGMIzyDAu4NjhUbd3YI9jS+eTLuzeSHN+exSN
// SIG // YIUG47WDFu2OZ1IvwVtwnV012Tn12dYeuq+fZEsJ4wZa
// SIG // i/QcGHhVSgziwl2OOPu+eLrTCvy8km2fNRWATfAkpMh5
// SIG // RKhWPgRzX6VL36qn8vg7qibzzOPj6vmjG9g6R8HjniSg
// SIG // +Is256ScHxHsZENa4dbn6kD/WVGURxTABfUEYGTY9hBE
// SIG // IfNjOqy+dB+G4R8k8ApDMSqT4J/MCOoi2dXO1EJsIs6w
// SIG // hnhlodJS3BITMYIC9TCCAvECAQEwgZMwfDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBIDIwMTACEzMAAACwhumSIApd6vgA
// SIG // AAAAALAwDQYJYIZIAWUDBAIBBQCgggEyMBoGCSqGSIb3
// SIG // DQEJAzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0BCQQx
// SIG // IgQgvBDktPR1GvKnM90LLrNcpDQQzti8KXWnKcPSTfNE
// SIG // yWswgeIGCyqGSIb3DQEJEAIMMYHSMIHPMIHMMIGxBBS8
// SIG // hPudWxLaxzaFO4hmnqMWGNXMHDCBmDCBgKR+MHwxCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAsIbpkiAK
// SIG // Xer4AAAAAACwMBYEFIrsUSfNp+vcbANMs4cNSbj79izo
// SIG // MA0GCSqGSIb3DQEBCwUABIIBANZaJQoDe+ujrUeFJz+1
// SIG // CLHWeEp6nIaF53/flsnfWyVe6c0cKXYtseJJ7meFrSOh
// SIG // xPQv+R7DzWX3xznb2ocUJrMpj5VYtIwtT0+9YbTOENqw
// SIG // w0XQqmlw7hJZ96khDqrcdaXqfkF1tfevX3Mg+H4I5gQv
// SIG // 6s3JYZoJcobqZHXnJ17MQC+l+pzHrWG8p9Rb6zzmcFs4
// SIG // aNmxzoXyqUdYm5HPMIaiQI2f2lGw1ifjzE+pbnO/rgZS
// SIG // /USElnhR+QNGfcjXtY1lNPFXD9ur7w314D725b21rh3M
// SIG // YdL0qQzRz8K/T+v1kDLWZLkCxBWwHRZ51SobzT4dfdS1
// SIG // LuSbNtyjEuiSo/o=
// SIG // End signature block
